-- license:BSD-3-Clause
-- copyright-holders:OzFalcon
local exports = {}
exports.name = "loadtable"
exports.version = "0.0.1"
exports.description = "Load table from file"
exports.license = "The BSD 3-Clause License"
exports.author = { name = "OzFalcon" }

local loadtable = exports

local loadtable_plugin_path = ""

function loadtable.set_folder(path)
	loadtable_plugin_path = path
end

function loadtable.startplugin()
	local table_value = "Nothing";
	local config_path = (loadtable_plugin_path .. "/loadtable.ini");

	local function test_table()
		-- Test Tables
		local file = io.open( config_path, "r" );
		if file then
			file:close()

			local _table = {}

			for line in io.lines(config_path) do
			  token, value = string.match(line, '([^ ]+) ([^ ]+)');
			  print("token = " .. token);
			  print("token Length = " .. string.len(token));
			  _table[token] = lfs.env_replace(value);
			  print("token value = " .. _table[token]);
			end

			table_value = _table["hi_path"];
		end
		return table_value
	end

	emu.register_start(function()
		print ("Test Table Value: " .. test_table() );
	end)

end

return exports