00100 	ORG	$3E00
00110 *
00120 BEGIN	ORCC	#$50	* TURN OFF BOTH INTERRUPTS
00130 *
00140 	LDA	#$32	* 0011 0010 SETS DD REGISTER
00150 	STA	$FF23	* ACCESS DATA DIR. REGISTER
00160 	LDA	#$FA	* 1111 1010 SETS S.B. OUTPUT
00170 	STA	$FF22	* TURN ON SINGLE BIT SOUND
00180 	LDA	#$36	* 0011 0110 SETS PD I/O
00190 	STA	$FF23	* RESTORE I/O CONFIGURATION
00200 *
00210 START	LDX	#MORSE	* POINT TO MORSE CODE TABLE
00220 	LDY	#TEXT	* POINT TO MESSAGE IN MEMORY
00230 AGAIN	LDB	,Y+	* GET VALUE FROM THE TEXT
00240 	CMPB	#$3C	* CHECK IF LESS-THAN SIGN
00250 	BEQ	START	* IF "<", THEN REPEAT MESSAGE
00260 	CMPB	#$3E	* CHECK IF GREATER-THAN SIGN
00270 	BEQ	OUT	* IF ">", RETURN TO BASIC
00280 	SUBB	#$20	* STRIP OFFSET (TABLE $20-$5B)
00290 	LDA	B,X	* ENCODED MORSE FROM TABLE
00300 	BEQ	SPACE	* IF 00, THEN SEND A SILENCE
00310 	PSHS	A	* SAVE ENCODED MORSE VALUE
00320 	CMPB	#$10	* CHECK IF PUNCTUATION
00330 	BLS	EXCEPT	* IF SO, GO TO EXCEPTION
00340 	CMPB	#$1A	* CHECK IF A COLON
00350 	BEQ	EXCEPT	* IF SO, GO TO EXCEPTION
00360 	CMPB	#$1F	* CHECK IF A QUESTION MARK
00370 	BNE	NORMAL	* IF NOT, PROCEED NORMALLY
00380 EXCEPT	ANDA	#$03	* EXCEPTION USES RIGHT 2 BITS
00390 	ASLA		* LEFT SHIFT CREATES NUMBER 6
00400 	BRA	GETVAL	* NOW READY FOR THE ACTION
00410 NORMAL	ANDA	#$07	* NORMAL USES RIGHT 3 BITS
00420 GETVAL	PULS	B	* RESTORE ENCODED MORSE VALUE
00430 NEWBIT	ROLB		* ROTATE BIT TO CARRY FLAG
00440 	BCS	JUMP1	* IF SET, THEN JUMP TO DAH
00450 	BSR	DIT	* OTHERWISE SEND A DIT
00460 	BRA	NEXT	* AND GO TO THE NEXT BIT
00470 JUMP1	BSR	DAH	* THEN SEND THE DAH
00480 NEXT	DECA		* SEE IF DONE WITH ALL BEEPS
00490 	BNE	NEWBIT	* IF NOT, THEN GET ANOTHER
00500 	LDB	#$04	* OTHERWISE GET TIMING VALUE
00510 LETRLP	BSR	QUIET	* AND CALL INTER-LETTER PAUSE
00520 	DECB		* DECREMENT PAUSE COUNTER
00530 	BNE	LETRLP	* AND LOOP BACK TILL DONE
00540 	BRA	AGAIN	* THEN GO BACK FOR MORE TEXT
00550 *
00560 SPACE	LDB	#$08	* 8 SILENCES FOR A SPACE
00570 SPCLP	BSR	QUIET	* AND GO SEND THE SILENCE
00580 	DECB		* DECREMENT THE SILENCE COUNT
00590 	BNE	SPCLP	* AND LOOP BACK TILL DONE
00600 	BRA	AGAIN	* AND GO GET NEXT TEXT
00610 *
00620 DAH	BSR	BEEP	* PERFORM FIRST 1/3 BEEP
00630 	BSR	BEEP	* PERFORM SECOND 1/3 BEEP
00640 DIT	BSR	BEEP	* PERFORM DIT OR LAST 1/3
00650 	BSR	QUIET	* AND PUT IN A SILENCE
00660 OUT	RTS		* BACK TO PROGRAM (OR BASIC)
00670 *
00680 BEEP	PSHS	A,B	* SAVE COUNT AND MORSE CODE
00690 	LDB	#100	* GET OUTSIDE BEEPWAVE VALUE
00700 OUTLP	LDA	#40	* GET INSIDE BEEPWAVE LENGTH
00710 INLP1	DECA		* DECREMENT INSIDE DELAY
00720 	BNE	INLP1	* AND WAIT TO TOTAL LOOPS
00730 	LDA	#$02	* GET HIGH PART OF BEEPWAVE
00740 	ORA	$FF22	* OR WITH PORT OUTPUT STATUS
00750 	STA	$FF22	* AND OUTPUT THE RESULT
00760 	LDA	#40	* GET ANOTHER DELAY VALUE
00770 INLP2	DECA		* AND COUNT DOWN THRU DELAY
00780 	BNE	INLP2	* WAIT THROUGH TOTAL LOOPS
00790 	LDA	#$FD	* SET LOW PART OF BEEPWAVE
00800 	ANDA	$FF22	* AND WITH CURRENT STATUS
00810 	STA	$FF22	* AND OUTPUT LOW BEEPWAVE
00820 	DECB		* DECREMENT NUMBER OF WAVES
00830 	BNE	OUTLP	* AND GO BACK TILL ALL DONE
00840 	PULS	A,B	* RESTORE COUNTER AND MORSE
00850 	RTS		* AND BACK TO PROGRAM
00860 *
00870 QUIET	PSHS	A,B	* SAVE COUNTER AND MORSE
00880 	LDB	#100	* GET OUTSIDE DELAY VALUE
00890 QLP1	LDA	#100	* GET INSIDE DELAY VALUE
00900 QLP2	DECA		* COUNT DOWN THRU INNER LOOP
00910 	BNE	QLP2	* AND WAIT FOR THE COUNT
00920 	DECB		* COUNT DOWN THRU OUTER LOOP
00930 	BNE	QLP1	* AND WAIT FOR THE COUNT
00940 	PULS	A,B	* RESTORE COUNTER AND MORSE
00950 	RTS		* BACK TO MAIN PROGRAM
00960 *
00970 MORSE	FCB	$00	* SPACE
00980 	FCB	$00	* ! = SPACE
00990 	FCB	$4B	* " (.-..-.) (010010 11) **
01000 	FCB	$00	* # = SPACE
01010 	FCB	$00	* $ = SPACE
01020 	FCB	$00	* % = SPACE
01030 	FCB	$00	* & = SPACE
01040 	FCB	$7B	* ' (.----.) (011110 11) **
01050 	FCB	$B7	* ( (-.--.-) (101101 11) **
01060 	FCB	$B7	* ) (-.--.-) (101101 11) **
01070 	FCB	$00	* * = SPACE
01080 	FCB	$00	* + = SPACE
01090 	FCB	$CF	* , (--..--) (110011 11) **
01100 	FCB	$87	* - (-....-) (100001 11) **
01110 	FCB	$57	* . (.-.-.-) (010101 11) **
01120 	FCB	$93	* / (-..-..) (100100 11) **
01130 	FCB	$FD	* 0 (-----) (11111 101)
01140 	FCB	$7D	* 1 (.----) (01111 101)
01150 	FCB	$3D	* 2 (..---) (00111 101)
01160 	FCB	$1D	* 3 (...--) (00011 101)
01170 	FCB	$0D	* 4 (....-) (00001 101)
01180 	FCB	$05	* 5 (.....) (00000 101)
01190 	FCB	$85	* 6 (-....) (10000 101)
01200 	FCB	$C5	* 7 (--...) (11000 101)
01210 	FCB	$E5	* 8 (---..) (11100 101)
01220 	FCB	$F5	* 9 (----.) (11110 101)
01230 	FCB	$E3	* : (---...) (111000 11) **
01240 	FCB	$00	* ; = SPACE
01250 	FCB	$00	* < = SPACE
01260 	FCB	$00	* = = SPACE
01270 	FCB	$00	* > = SPACE
01280 	FCB	$33	* ? (..--..) (001100 11) **
01290 	FCB	$00	* @ = SPACE
01300 	FCB	$41	* A (.-) (01 000 001)
01310 	FCB	$84	* B (-...) (1000 0 100)
01320 	FCB	$A4	* C (-.-.) (1010 0 100)
01330 	FCB	$83	* D (-..) (100 00 011)
01340 	FCB	$01	* E (.) (0 0000 001)
01350 	FCB	$24	* F (..-.) (0010 0 100)
01360 	FCB	$C3	* G (--.) (110 00 011)
01370 	FCB	$04	* H (....) (0000 0 100)
01380 	FCB	$02	* I (..) (00 000 010)
01390 	FCB	$74	* J (.---) (0111 0 100)
01400 	FCB	$A3	* K (-.-) (101 00 011)
01410 	FCB	$44	* L (.-..) (0100 0 100)
01420 	FCB	$C2	* M (--) (11 000 010)
01430 	FCB	$82	* N (-.) (10 000 010)
01440 	FCB	$E3	* O (---) (111 00 011)
01450 	FCB	$64	* P (.--.) (0110 0 100)
01460 	FCB	$D4	* Q (--.-) (1101 0 100)
01470 	FCB	$43	* R (.-.) (010 00 011)
01480 	FCB	$03	* S (...) (000 00 011)
01490 	FCB	$81	* T (-) (1 0000 001)
01500 	FCB	$23	* U (..-) (001 00 011)
01510 	FCB	$14	* V (...-) (0001 0 100)
01520 	FCB	$63	* W (.--) (011 00 011)
01530 	FCB	$94	* X (-..-) (1001 0 100)
01540 	FCB	$B4	* Y (-.--) (1011 0 100)
01550 	FCB	$C4	* Z (--..) (1100 0 100)
01560 * NOTE:
01570 * THE ITEMS MARKED WITH A DOUBLE ASTERISK (**) ARE
01580 * PROCESSED BY THE EXCEPTION BEEPING ROUTINE.
01590 *
01600 TEXT	FCC	/YOU ARE LISTENING TO THE /
01610 	FCC	/MICRO LANGUAGE LAB, PRESENTED /
01620 	FCC	/BY GREEN MOUNTAIN MICRO.>/
01630 *
01640 	END	BEGIN
